<?php

App::uses('AppModel', 'Model');
App::uses('File', 'Utility');

class Install extends AppModel
{

    public $name = 'Install';

    public $useTable = false;
    
    public $cacheSources = false;
    
    public $validate = array(
        'host' => array(
            'notBlank' => array(
                'rule' => 'notBlank',
                'message' => 'Database Host URL can not be empty.'
            )
        ),
        'login' => array(
            'notBlank' => array(
                'rule' => 'notBlank',
                'message' => 'Database Username can not be empty.'
            )
        ),
        'database' => array(
            'notBlank' => array(
                'rule' => 'notBlank',
                'message' => 'Database name can not be empty.'
            )
        )
    );

    public function createDatabaseFile($data)
    {
        $config = array(
            'name'       => 'default',
            'datasource' => 'Database/Mysql',
            'persistent' => false,
            'host'       => 'localhost',
            'login'      => 'root',
            'password'   => '',
            'database'   => '',
            'schema'     => null,
            'prefix'     => null,
            'encoding'   => 'UTF8',
            'port'       => null,
        );

        foreach ($data[ 'Install' ] as $key => $value) {
            if (isset($data[ 'Install' ][ $key ])) {
                $config[ $key ] = $value;
            }
        }

        $result = copy(APP . 'Config' . DS . 'database.php.install', APP . 'Config' . DS . 'database.php');
        if (!$result) {
            return __('Could not copy database.php file.');
        }
        $file    = new File(APP . 'Config' . DS . 'database.php', true);
        $content = $file->read();

        foreach ($config as $configKey => $configValue) {
            $content = str_replace('{default_' . $configKey . '}', $configValue, $content);
        }

        if (!$file->write($content)) {
            return __('Could not write database.php file.');
        }

        try {
            App::uses('ConnectionManager', 'Model');
            ConnectionManager::create('default', $config);
            $db = ConnectionManager::getDataSource('default');
        } catch (MissingDatasourceException $e) {
            return __('Could not connect to database: ') . $e->getMessage();
        }
        if (!($db && $db->isConnected())) {
            return __('Could not connect to database.');
        }

        return true;
    }

    /**
     * Run Migrations and add data in table
     *
     * @return bool True if migrations have succeeded
     */
    public function runMigrations()
    {

        // Get the phinx console application and inject it into TextWrapper.
        $app = require APP . 'Vendor' . DS . 'robmorgan' . DS . 'phinx' . DS . 'app' . DS . 'phinx.php';

        $options = array(
            'configuration' => APP . 'phinx.php',
            'parser'        => 'php'
        );
        $wrap    = new \Phinx\Wrapper\TextWrapper($app, $options);

        // Mapping of route names to commands.
        $routes = array(
            'status'   => 'getStatus',
            'migrate'  => 'getMigrate',
            'rollback' => 'getRollback',
        );

        $command = 'migrate';

        // Get the environment and target version parameters.
        $env    = 'default';
        //$env    = null;
        $target = null;

        // Execute the command and determine if it was successful.
        $output = call_user_func(array( $wrap, $routes[ $command ] ), $env, $target);

        $error = $wrap->getExitCode() > 0;

        if ($error) {
            return 'Unable to build database.';
        }

        return true;
    }

    /**
     * Create admin user
     *
     * @var array $user User datas
     * @return If user is created
     */
    public function addAdminUser($user)
    {
        $User = ClassRegistry::init('User');

        $user[ 'User' ][ 'username' ]            = strtolower($user[ 'User' ][ 'username' ]);
        $user[ 'User' ][ 'register_ip' ]         = get_ip();
        $user[ 'User' ][ 'account_type' ]        = 'Admin';
        $user[ 'User' ][ 'status' ]              = 'Active';
        $user[ 'User' ][ 'redirection_type' ]    = 1;
        $user[ 'User' ][ 'plan_id' ]             = 1;
        $user[ 'User' ][ 'timer' ]               = 5;
        $user[ 'User' ][ 'user_activation_key' ] = '';
        $user[ 'User' ][ 'api_key' ]             = sha1(uniqid());

        $User->create();
        $saved = $User->save($user);
        if (!$saved) {
            $this->log('Unable to create administrative user. Validation errors:');
            $this->log($User->validationErrors);
        }
        return $saved;
    }
}
